(function($){
	"use strict";
    
    // Convert All Image to SVG
    $('img.svg').each(function() {
         var $img = $(this),
             imgID = $img.attr('id'),
             imgClass = $img.attr('class'),
             imgURL = $img.attr('src');

         $.get(imgURL, function(data) {
             // Get the SVG tag, ignore the rest
             var $svg = $(data).find('svg');

             // Add replaced image's ID to the new SVG
             if (typeof imgID !== 'undefined') {
                 $svg = $svg.attr('id', imgID);
             }
             // Add replaced image's classes to the new SVG
             if (typeof imgClass !== 'undefined') {
                 $svg = $svg.attr('class', imgClass);
             }

             // Remove any invalid XML tags as per http://validator.w3.org
             $svg = $svg.removeAttr('xmlns:a');

             // Replace image with new SVG
             $img.replaceWith($svg);
        }, 'xml');
    });

     $("#header_nav").sticky({topSpacing:0});
    
    //for mobile menu
    $( '.toggle-inner' ).on( 'click', function (e) {
        e.preventDefault();
        var mask = '<div class="mask-overlay">';

        $( 'body' ).toggleClass( 'active' );
        $(mask).hide().appendTo( 'body' ).fadeIn( 'fast' );
        $( '.mask-overlay, .close-menu' ).on( 'click', function() {
            $( 'body' ).removeClass( 'active' );
            $( '.mask-overlay' ).remove();
        });
    });
    
    var Accordion = function (el, multiple) {
        this.el = el || {};

        this.multiple = multiple || false;

        var dropdownlink = this.el.find('.dropdownlink');
        dropdownlink.on('click', {
                el: this.el,
                multiple: this.multiple
            },
            this.dropdown);
    };
    
    Accordion.prototype.dropdown = function (e) {
        e.preventDefault();
        var $el = e.data.el,
             $this = $(this),

            $next = $this.next();

        $next.slideToggle();
        $this.parent().toggleClass('open');

        if (!e.data.multiple) {
            //show only one menu at the same time
            $el.find('.submenuItems').not($next).slideUp().parent().removeClass('open');
        }
    }
    var accordion = new Accordion($('.accordion-menu'), false);
    
    //blog masonry
    $(window).on('resize',function(){
        $('.post').masonry({
            itemSelector: '.post-item',
            columnWidth: '.post-sizer',
            percentPosition: true
        });
    });
    
    //chat area
    $(".live_chat_btn").on('click',function(){
        $('.live_chat_form').addClass('active');
    })
    $('.live_chat_form h3').on('click',function(){
        $('.live_chat_form').removeClass('active');
            
    });
    
    //magnific popup
    $('.video_play').magnificPopup({
        type: 'iframe'
    });
    
    //backgroundmove js
    $('.domain_register_area').backgroundMove({
        movementStrength:'50'
    });
    
    //texillate js
    $('.dm_register_heading h2').textillate({
        selector: '.texts',
        loop: true,
        minDisplayTime: 2000,
        initialDelay: 0,
        autoStart: true,
        in: {
            effect: 'fadeInLeft',
            delayScale: 1.5,
            delay: 50
        },
        out: {
            effect: 'fadeOutLeft',
            delayScale: 1.5,
            delay: 50
        }
    });
    
    //domain promo
    $('.domain_promo_slider').owlCarousel({
        items:4,
        loop:true,
        nav:true,
        autoplay:true,
        autoplayTimeout:2000,
        smartSpeed:250,
        navText:['<i class="fa fa-angle-left"></i>','<i class="fa fa-angle-right"></i>'],
        responsive:{
            300:{
                items:2
            },
            480:{
                items:3
            },
            768:{
                items:3
            },
            992:{
                items:4
            }
        }
    })
    
    //related post slider
    $('.related_post_slider').owlCarousel({
        items:3,
        loop:true,
        nav:true,
        navText:['<i class="fa fa-arrow-left"></i><span>Previous Post</span>','<span>Next Post</span><i class="fa fa-arrow-right"></i>'],
        margin:20,
        responsive:{
            300:{
                items:1
            },
            480:{
                items:1
            },
            768:{
                items:2 
            },
            992:{
                items:3
            }
        }
    })
    
    //progress bar
    var waypoints = $('.progress-bar').waypoint(function(direction) {
        $('.progress .progress-bar').progressbar();
    }, {
        offset: '10%'
    });
    
    //swipper runner
    $('.swiper-container').each(function() {
        new SwiperRunner($(this));
    });
    var obj = new SwiperRunner('.gallery-top');
    obj.setNav('.gallery-thumbs');
    
    //partner
    $('.whmch_whost_partner_slider').owlCarousel({
        items:4,
        loop:true
    });
    
    //counterup
    $('.counter').counterUp({
        delay: 10,
        time: 1000
    });   

    // Animate the scroll to top
    $('.back_to_top').on('click', function(event) {
        event.preventDefault();
        $('html, body').animate({scrollTop: 0}, 2000);
    });
    
    //twitter fetcher
        var config4 = {
        "id": '693671421331922946',
        "domId": 'twitter_feed',
        "maxTweets": 2,
        "enableLinks": false,
        "showUser": false,
        "showTime": true,
        "showRetweet": false,
        "dateFunction":''
    };
    $('#twitter_feed').each(function() {
        twitterFetcher.fetch(config4);
    });
    
    //range slider  
    $('input[type="range"]').rangeslider({
        polyfill: false,
        onSlide:function(position, value){
          var $class = '.item' + value;

          $('.range_plan .range_item').removeClass('active');
          $($class, '.range_plan').addClass('active');
        }
    });
    
    //google map
	var googleMapSelector = $('#contactGoogleMap'),
		myCenter = new google.maps.LatLng(23.7743812,90.4098301);

	function initialize() {
		var mapProp = {
			center: myCenter,
			zoom: 14,
			scrollwheel: false,
			mapTypeId: google.maps.MapTypeId.ROADMAP,
			styles:

			[
				{
					"featureType": "administrative",
					"elementType": "geometry",
					"stylers": [
						{
							"visibility": "on"
						}
					]
				},
				{
					"featureType": "administrative",
					"elementType": "geometry.fill",
					"stylers": [
						{
							"visibility": "on"
						}
					]
				},
				{
					"featureType": "administrative",
					"elementType": "geometry.stroke",
					"stylers": [
						{
							"visibility": "on"
						}
					]
				},
				{
					"featureType": "administrative",
					"elementType": "labels.text",
					"stylers": [
						{
							"visibility": "on"
						}
					]
				}
			]
		};
		var map = new google.maps.Map(document.getElementById("contactGoogleMap"), mapProp);
		var marker = new google.maps.Marker({
			position: myCenter,
			icon: 'images/map-marker.png'
		});
		marker.setMap(map);
	}
	if (googleMapSelector.length) {
		google.maps.event.addDomListener(window, 'load', initialize);
	}
    
    //preloader
     $(window).load(function() {
        $("#loading").delay(1000).fadeOut("slow");
    });
        
})(jQuery);